namespace Podela_Jabuka
{
    internal class Program
    {
        public static void UnosPodataka(out long a, out long b, out long c)
        {
            long[] input = Array.ConvertAll(Console.ReadLine().Split(' '), long.Parse);
            a = input[0];
            b = input[1];
            c = input[2];
        }

        // Funkcija koja sortira tri broja u rastucem redosledu
        public static void Sortiraj(ref long a, ref long b, ref long c)
        {
            long tempa = a;
            long tempb = b;
            long tempc = c;
            a = Math.Min(tempa, Math.Min(tempb, tempc));
            c = Math.Max(tempa, Math.Max(tempb, tempc));
            b = tempa + tempb + tempc - a - c;
        }

        public static bool NemozeDaSeRaspodeli(long a, long b, long c, long NaKrajuImaju)
        {
            long najmanjaRazlika = a - NaKrajuImaju;
            long najvecaRazlika = c - NaKrajuImaju;
            long srednjaRazlika = b - NaKrajuImaju;
            if(najmanjaRazlika == -1 && srednjaRazlika == 0 && najvecaRazlika == 1) return true;
            return false;
        }

        public static bool MoguDaRaspodeleJabuke(long a, long b, long c)
        {
            // Provera da li je zbir deljiv sa 3
            if ((a + b + c) % 3 != 0) return false;

            // Svi treba da imaju isti broj jabuka
            long naKrajuImaju = (a + b + c) / 3;

            while (a != naKrajuImaju || b != naKrajuImaju || c != naKrajuImaju)
            {
                Sortiraj(ref a, ref b, ref c);
                if (NemozeDaSeRaspodeli(a, b, c, naKrajuImaju)) return false;
                a += 2; b--; c--;
            }

            return true;
        }

        static void Main(string[] args)
        {
            // Unos podataka
            UnosPodataka(out long a, out long b, out long c);

            // Provera da li mogu da raspodele jabuke i ispis rezultata
            Console.WriteLine(MoguDaRaspodeleJabuke(a, b, c) ? "DA" : "NE");
        }
    }
}